package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Secuencias;
import com.ejie.ab04b.model.ModalidadOrganizacionPreventiva;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab04b74s00DaoImpl generated by UDA, 11-Jan-2017 12:23:07.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class ModalidadOrganizacionPreventivaDaoImpl implements
		ModalidadOrganizacionPreventivaDao {

	private JdbcTemplate jdbcTemplate;

	private static final String QUERY_SELECT = "SELECT t1.TIPMPR_074 TIPMPR074, t1.DESMPR_EU_074 DESMPREU074, t1.DESMPR_ES_074 DESMPRES074, t1.FECBAJ_074 FECBAJ074 FROM AB0474S00 t1 ";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<ModalidadOrganizacionPreventiva> rwMap = new RowMapper<ModalidadOrganizacionPreventiva>() {
		public ModalidadOrganizacionPreventiva mapRow(ResultSet resultSet,
				int rowNum) throws SQLException {
			return new ModalidadOrganizacionPreventiva(
					resultSet.getString("TIPMPR074"),
					resultSet.getString("DESMPREU074"),
					resultSet.getString("DESMPRES074"),
					resultSet.getDate("FECBAJ074"));
		}
	};

	private RowMapper<ModalidadOrganizacionPreventiva> rwMapPK = new RowMapper<ModalidadOrganizacionPreventiva>() {
		public ModalidadOrganizacionPreventiva mapRow(ResultSet resultSet,
				int rowNum) throws SQLException {
			return new ModalidadOrganizacionPreventiva(
					resultSet.getString("TIPMPR074"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab04b74s00 table.
	 * 
	 *  ab0474s00
	 *            Ab04b74s00
	 *  Ab04b74s00
	 *
	 * @param ab0474s00 the ab 0474 s 00
	 * @return the modalidad organizacion preventiva
	 */
	public ModalidadOrganizacionPreventiva add(
			ModalidadOrganizacionPreventiva ab0474s00) {
		Long modalidadPreventivaPK = Secuencias.MODALIDAD_PREVENTIVA
				.getNextLong(this.jdbcTemplate);
		if (modalidadPreventivaPK != null) {
			ab0474s00.setTipmpr074(modalidadPreventivaPK.toString());
		}

		String query = "INSERT INTO AB0474S00 (TIPMPR_074, DESMPR_EU_074, DESMPR_ES_074, FECBAJ_074) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, ab0474s00.getTipmpr074(),
				ab0474s00.getDesmprEu074(), ab0474s00.getDesmprEs074(),
				ab0474s00.getFecbaj074());
		return ab0474s00;
	}

	/**
	 * Updates a single row in the Ab04b74s00 table.
	 * 
	 *  ab0474s00
	 *            Ab04b74s00
	 *  Ab04b74s00
	 *
	 * @param ab0474s00 the ab 0474 s 00
	 * @return the modalidad organizacion preventiva
	 */
	public ModalidadOrganizacionPreventiva update(
			ModalidadOrganizacionPreventiva ab0474s00) {
		String query = "UPDATE AB0474S00 SET DESMPR_EU_074=?, DESMPR_ES_074=?, FECBAJ_074=? WHERE TIPMPR_074=? ";
		this.jdbcTemplate.update(query, ab0474s00.getDesmprEu074(),
				ab0474s00.getDesmprEs074(), ab0474s00.getFecbaj074(),
				ab0474s00.getTipmpr074());
		return ab0474s00;
	}

	/**
	 * Finds a single row in the Ab04b74s00 table.
	 * 
	 *  ab0474s00
	 *            Ab04b74s00
	 *  Ab04b74s00
	 *
	 * @param ab0474s00 the ab 0474 s 00
	 * @return the modalidad organizacion preventiva
	 */
	@Transactional(readOnly = true)
	public ModalidadOrganizacionPreventiva find(
			ModalidadOrganizacionPreventiva ab0474s00) {
		StringBuilder query = new StringBuilder(
				ModalidadOrganizacionPreventivaDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.TIPMPR_074 = ? ");

		List<ModalidadOrganizacionPreventiva> ab0474s00List = this.jdbcTemplate
				.query(query.toString(), this.rwMap, ab0474s00.getTipmpr074());
		return (ModalidadOrganizacionPreventiva) DataAccessUtils
				.uniqueResult(ab0474s00List);
	}

	/**
	 * Removes a single row in the Ab04b74s00 table.
	 * 
	 *  ab0474s00            Ab04b74s00
	 *
	 * @param ab0474s00 the ab 0474 s 00
	 */
	public void remove(ModalidadOrganizacionPreventiva ab0474s00) {
		String query = "DELETE FROM AB0474S00 WHERE TIPMPR_074=?";
		this.jdbcTemplate.update(query, ab0474s00.getTipmpr074());
	}

	/**
	 * Finds a list of rows in the Ab04b74s00 table.
	 * 
	 *  ab0474s00
	 *            Ab04b74s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab04b74s00>
	 *
	 * @param ab0474s00 the ab 0474 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<ModalidadOrganizacionPreventiva> findAll(
			ModalidadOrganizacionPreventiva ab0474s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				ModalidadOrganizacionPreventivaDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0474s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<ModalidadOrganizacionPreventiva>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab04b74s00 table using like.
	 * 
	 *  ab0474s00
	 *            Ab04b74s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab04b74s00>
	 *
	 * @param ab0474s00 the ab 0474 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<ModalidadOrganizacionPreventiva> findAllLike(
			ModalidadOrganizacionPreventiva ab0474s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				ModalidadOrganizacionPreventivaDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0474s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<ModalidadOrganizacionPreventiva>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab04b74s00 table.
	 * 
	 *  ab0474s00
	 *            Ab04b74s00
	 *  Long
	 *
	 * @param ab0474s00 the ab 0474 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(ModalidadOrganizacionPreventiva ab0474s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0474S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0474s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab04b74s00 table using like.
	 * 
	 *  ab0474s00
	 *            Ab04b74s00
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param ab0474s00 the ab 0474 s 00
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(ModalidadOrganizacionPreventiva ab0474s00,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0474S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0474s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab04b74s00 selected for rup_table.
	 * 
	 *  ab0474s00            Ab04b74s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab04b74s00>>
	 *
	 * @param ab0474s00 the ab 0474 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<ModalidadOrganizacionPreventiva>> reorderSelection(
			ModalidadOrganizacionPreventiva ab0474s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				ModalidadOrganizacionPreventivaDaoImpl.QUERY_SELECT);
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0474s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, ModalidadOrganizacionPreventiva.class,
				filterParamList,
				"TIPMPR_074,DESMPR_EU_074,DESMPR_ES_074,FECBAJ_074");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<ModalidadOrganizacionPreventiva>(
						this.rwMapPK, jqGridRequestDto), filterParamList
						.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            Ab04b74s00
	 *  searchParams            Ab04b74s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab04b74s00>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<ModalidadOrganizacionPreventiva>> search(
			ModalidadOrganizacionPreventiva filterParams,
			ModalidadOrganizacionPreventiva searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				ModalidadOrganizacionPreventivaDaoImpl.QUERY_SELECT);
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings(value = "unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, ModalidadOrganizacionPreventiva.class,
				filterParamList, searchSQL, searchParamList, from_alias,
				"TIPMPR_074,DESMPR_EU_074,DESMPR_ES_074,FECBAJ_074");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<ModalidadOrganizacionPreventiva>(
						this.rwMapPK, jqGridRequestDto), filterParamList
						.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 *  filterab0474s00            Ab04b74s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *
	 * @param filterab0474s00 the filterab 0474 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	@Override()
	public void removeMultiple(ModalidadOrganizacionPreventiva filterab0474s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				ModalidadOrganizacionPreventivaDaoImpl.QUERY_SELECT);

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab0474s00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings(value = "unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto,
						ModalidadOrganizacionPreventiva.class, query, params,
						"TIPMPR_074,DESMPR_EU_074,DESMPR_ES_074,FECBAJ_074");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab04b74s00 entity.
	 * 
	 *  ab0474s00            Ab04b74s00 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0474s00 the ab 0474 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(ModalidadOrganizacionPreventiva ab0474s00) {

		StringBuilder where = new StringBuilder(
				ModalidadOrganizacionPreventivaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0474s00 != null && ab0474s00.getTipmpr074() != null) {
			where.append(" AND t1.TIPMPR_074 = ?");
			params.add(ab0474s00.getTipmpr074());
		}
		if (ab0474s00 != null && ab0474s00.getDesmprEu074() != null) {
			where.append(" AND t1.DESMPR_EU_074 = ?");
			params.add(ab0474s00.getDesmprEu074());
		}
		if (ab0474s00 != null && ab0474s00.getDesmprEs074() != null) {
			where.append(" AND t1.DESMPR_ES_074 = ?");
			params.add(ab0474s00.getDesmprEs074());
		}
		if (ab0474s00 != null && ab0474s00.getFecbajaDesde() != null) {
			where.append(" AND t1.FECBAJ_074 >= ?");
			params.add(ab0474s00.getFecbajaDesde());
		}
		if (ab0474s00 != null && ab0474s00.getFecbajaHasta() != null) {
			where.append(" AND t1.FECBAJ_074 <= ?");
			params.add(ab0474s00.getFecbajaHasta());
		}
		//where.append(" AND (t1.FECBAJ_074 IS NULL OR t1.FECBAJ_074 > SYSDATE)");

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab04b74s00 entity.
	 * 
	 *  ab0474s00            Ab04b74s00 Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0474s00 the ab 0474 s 00
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(
			ModalidadOrganizacionPreventiva ab0474s00, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ModalidadOrganizacionPreventivaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0474s00 != null && ab0474s00.getTipmpr074() != null) {
			where.append(" AND UPPER(t1.TIPMPR_074) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0474s00.getTipmpr074().toUpperCase() + "%");
			} else {
				params.add("%" + ab0474s00.getTipmpr074().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPMPR_074 IS NOT NULL");
		}
		if (ab0474s00 != null && ab0474s00.getDesmprEu074() != null) {
			where.append(" AND UPPER(t1.DESMPR_EU_074) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0474s00.getDesmprEu074().toUpperCase() + "%");
			} else {
				params.add("%" + ab0474s00.getDesmprEu074().toUpperCase() + "%");
			}
			where.append(" AND t1.DESMPR_EU_074 IS NOT NULL");
		}
		if (ab0474s00 != null && ab0474s00.getDesmprEs074() != null) {
			where.append(" AND UPPER(t1.DESMPR_ES_074) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0474s00.getDesmprEs074().toUpperCase() + "%");
			} else {
				params.add("%" + ab0474s00.getDesmprEs074().toUpperCase() + "%");
			}
			where.append(" AND t1.DESMPR_ES_074 IS NOT NULL");
		}
		if (ab0474s00 != null && ab0474s00.getFecbajaDesde() != null) {
			where.append(" AND t1.FECBAJ_074 >= ?");
			params.add(ab0474s00.getFecbajaDesde());
		}
		if (ab0474s00 != null && ab0474s00.getFecbajaHasta() != null) {
			where.append(" AND t1.FECBAJ_074 <= ?");
			params.add(ab0474s00.getFecbajaHasta());
		}
		if(ab0474s00 != null && ab0474s00.getFecbajaDesde() == null && ab0474s00.getFecbajaHasta() == null){
			where.append(" AND (t1.FECBAJ_074 IS NULL OR t1.FECBAJ_074 > SYSDATE)");
		}
		//where.append(" AND (t1.FECBAJ_074 IS NULL OR t1.FECBAJ_074 > SYSDATE)");

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
